//
//  ViewController.swift
//  SwiftCamera
//
//  Created by Yoshihisa Nitta on 2017/04/27.
//  Copyright © 2017年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    @IBOutlet weak var myImageView: UIImageView!
    @IBAction func goCamera(_ sender: Any) {
        let camera = UIImagePickerControllerSourceType.camera
        if UIImagePickerController.isSourceTypeAvailable(camera) {
            let picker = UIImagePickerController()
            picker.sourceType = camera
            picker.delegate = self
            present(picker, animated: true, completion: nil)
        } else {
            print("camera is unavailable")
        }
    }
    
    func imagePickerController(_ picker:UIImagePickerController, didFinishPickingMediaWithInfo info: [String : Any]) {
        let image = info[UIImagePickerControllerOriginalImage] as! UIImage
        self.myImageView.image = image
        UIImageWriteToSavedPhotosAlbum(image,nil,nil,nil)
        dismiss(animated: true, completion: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

