//
//  ObjCWrapper.m
//  SwiftOpenCV
//
//  Created by Yoshihisa Nitta on 2016/06/17.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

#import "ObjCWrapper.h"
#import <opencv2/opencv.hpp>
#import <opencv2/highgui/ios.h>

using namespace std;

@implementation ObjCWrapper

cv::CascadeClassifier cascade;
bool active;

- (bool) isActive { return active; }

- (bool) setXML: (NSString *) name {
    NSBundle *bundle = [NSBundle mainBundle];
    NSString *path = [bundle pathForResource: name ofType:@"xml"];
    string cascadeName = (char *) [path UTF8String];
    if (!cascade.load(cascadeName)) {
        return active = false;
    }
    return active = true;
}

- (int) detect: (UIImage *) image founds: (NSMutableArray *) arr {
    CGColorSpaceRef colorSpace = CGImageGetColorSpace(image.CGImage);
    CGFloat cols = image.size.width;
    CGFloat rows = image.size.height;
    cv::Mat mat(rows,cols,CV_8UC4);
    CGContextRef contextRef = CGBitmapContextCreate(mat.data, cols, rows, 8, mat.step[0], colorSpace, kCGImageAlphaNoneSkipLast);
    CGContextDrawImage(contextRef, CGRectMake(0, 0, cols, rows), image.CGImage);
    CGContextRelease(contextRef);
    
    vector<cv::Rect> founds;
    cascade.detectMultiScale(mat, founds, 1.1, 2, CV_HAAR_SCALE_IMAGE,cv::Size(30,30));
    
    for (int i=0; i<founds.size(); i++) {
        cv::Rect rect = founds[i];
        [arr addObject: [NSNumber numberWithInteger: rect.x]];
        [arr addObject: [NSNumber numberWithInteger: rect.y]];
        [arr addObject: [NSNumber numberWithInteger: rect.width]];
        [arr addObject: [NSNumber numberWithInteger: rect.height]];
    }
    
    return (int) [arr count];
}

@end
