//
//  ViewController.swift
//  SwiftLocalNotification
//
//  Created by Yoshihisa Nitta on 2016/07/11.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var myLabel: UILabel!
    @IBAction func tapButton(sender: AnyObject) {
        let app = UIApplication.sharedApplication()
        app.cancelAllLocalNotifications();
        app.registerUserNotificationSettings(UIUserNotificationSettings(forTypes: [.Sound, .Alert, .Badge], categories: nil))
        
        let date = NSDate().dateByAddingTimeInterval(NSTimeInterval(5.0))
        let notification = UILocalNotification()
        notification.alertBody = "Time has reached"
        notification.alertAction = "OK"
        notification.soundName = UILocalNotificationDefaultSoundName
        notification.timeZone = NSTimeZone.defaultTimeZone()
        notification.fireDate = date
        app.scheduleLocalNotification(notification)
    }
        
    override func viewDidLoad() {
        super.viewDidLoad()
        let appDelegate = UIApplication.sharedApplication().delegate as! AppDelegate
        if let msg = appDelegate.notifiedMessage {
            myLabel.text = msg
        }
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }


}

