//
//  ViewController.swift
//  SwiftHorizontalPicker
//
//  Created by Yoshihisa Nitta on 2016/05/29.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class ViewController: UIViewController, AKPickerViewDelegate, AKPickerViewDataSource {
    @IBOutlet weak var picker: AKPickerView!

    let values:[String] = ["apple","orange","peach","melon","grape","lemon"]
    
    func numberOfItemsInPickerView(pickerView: AKPickerView) -> Int {
        return values.count
    }
    
    func pickerView(pickerView: AKPickerView, titleForItem item: Int) -> String {
        return " " + values[item] + " "
    }
    
    func pickerView(pickerView: AKPickerView, didSelectItem row: Int) {
        print("select " + values[row])
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        picker.delegate = self
        picker.dataSource = self
        picker.font = UIFont(name: "HelveticaNeue-Light", size: 20)!
        picker.highlightedFont = UIFont(name: "HelveticaNeue", size: 20)!
        picker.pickerViewStyle = .Wheel
        picker.maskDisabled = false
        picker.reloadData()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}

