//
//  ViewController.swift
//  SwiftGravity
//
//  Created by Yoshihisa Nitta on 2016/05/27.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit
import CoreMotion

class ViewController: UIViewController {
    @IBOutlet weak var myBall: UIImageView!
    let cmManager = CMMotionManager()
    let scrSize: CGSize = UIScreen.mainScreen().bounds.size
    let mag: Double = 20.0
    var vx, vy: Double?

    override func viewDidLoad() {
        super.viewDidLoad()
        vx = 0.0
        vy = 0.0
        startGame()
    }
    
    func startGame() {
        cmManager.deviceMotionUpdateInterval = 0.1
        let handler: CMDeviceMotionHandler = {
            (motionData: CMDeviceMotion?, error: NSError?) -> Void in
            self.stepGame(motionData, error: error)
        }
        cmManager.startDeviceMotionUpdatesToQueue(NSOperationQueue.mainQueue(), withHandler: handler)
    }
    
    func stepGame(motionData: CMDeviceMotion?, error: NSError?) {
        var xMin, xMax, yMin, yMax: Int
        xMin = Int(myBall.frame.width / 2)
        xMax = Int(scrSize.width) - xMin
        yMin = Int(myBall.frame.height / 2)
        yMax = Int(scrSize.height) - yMin
        if let motion = motionData {
            let gravity = motion.gravity
            vx = vx! + gravity.x * mag
            vy = vy! - gravity.y * mag
            var x: Int = Int(Double(myBall.center.x) + vx!)
            var y: Int = Int(Double(myBall.center.y) + vy!)
            if (x < xMin) {
                x = xMin; vx = 0.0
            } else if (x > xMax) {
                x = xMax; vx = 0.0
            }
            if (y < yMin) {
                y = yMin; vy = 0.0
            } else if (y > yMax) {
                y = yMax; vy = 0.0
            }
            myBall.center = CGPoint(x: x,y: y)
        }
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

