//
//  ViewController.swift
//  SwiftGesturePinch
//
//  Created by Yoshihisa Nitta on 2016/07/13.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    var rects: [CGRect]?
    var backupImage: UIImage?

    @IBOutlet weak var myImageView: UIImageView!
    @IBAction func pinchImageView(sender: UIPinchGestureRecognizer) {
        var r: CGRect?
        if (sender.numberOfTouches() >= 2) {
            let p:CGPoint = sender.locationOfTouch(0, inView: myImageView)
            let q:CGPoint = sender.locationOfTouch(1, inView: myImageView)
            r = CGRect(x: min(p.x,q.x), y: min(p.y,q.y), width: abs(p.x-q.x), height: abs(p.y-q.y))
        }
        switch sender.state {
        case .Began:
            print("began \(r)")
            backupImage = myImageView.image
            if r != nil {
                myImageView.image = makeUIImage(backupImage, r)
             }
       case .Changed:
        print("changed \(r)")
        if r != nil {
            myImageView.image = makeUIImage(backupImage, r)
        }
       case .Ended:
            print("ended \(r)")
            if r != nil {
                myImageView.image = makeUIImage(backupImage, r)
                rects!.append(r!)
            }
        default:
            print("default \(r)")
         }
    }
    
    func makeUIImage(image: UIImage?, _ rect:CGRect?) -> UIImage {
        let sz:CGSize = myImageView.frame.size
        UIGraphicsBeginImageContext(sz)
        let context: CGContextRef = UIGraphicsGetCurrentContext()!
        if image != nil {
            image!.drawInRect(CGRectMake(0,0,image!.size.width,image!.size.height))
        }
        CGContextSetLineWidth(context, 1.0)
        CGContextSetRGBStrokeColor(context, 1.0, 0.0, 0.0, 1.0)
        if rect != nil {
            CGContextStrokeRect(context, rect!)
        }
        let img = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return img
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        rects = Array<CGRect>()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}

