//
//  ViewController.swift
//  SwiftGeo
//
//  Created by Yoshihisa Nitta on 2016/05/30.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit
import CoreLocation

class ViewController: UIViewController, CLLocationManagerDelegate {
    @IBOutlet weak var latLabel: UILabel!
    @IBOutlet weak var lngLabel: UILabel!
    @IBOutlet weak var altLabel: UILabel!
    @IBOutlet weak var argLabel: UILabel!
    @IBOutlet weak var dirLabel: UILabel!
    @IBOutlet weak var northSwitch: UISegmentedControl!
    @IBOutlet weak var compassFG: UIImageView!
    
    let lm = CLLocationManager()

    @IBAction func tapStart(sender: AnyObject) {
        disabledLocationLabel()
        lm.requestWhenInUseAuthorization()
        lm.delegate = self
        startLocationService()
        startHeadingService()
    }
    @IBAction func tapStop(sender: AnyObject) {
        lm.stopUpdatingLocation()
        lm.stopUpdatingHeading()
   }
    
    func locationManager(manager: CLLocationManager, didUpdateLocations locations:[CLLocation]) {
        let locationData = locations.last
        if let lng = locationData?.coordinate.longitude {
            lngLabel.text = String(format:"%.6f",lng)
        }
        if let lat = locationData?.coordinate.latitude {
            latLabel.text = String(format:"%.6f",lat)
        }
        if let alt = locationData?.altitude {
            altLabel.text = String(format:"%.6f",alt)
        }
    }
    
    func locationManager(manager: CLLocationManager, didChangeAuthorizationStatus status: CLAuthorizationStatus) {
        switch status {
        case .AuthorizedAlways, .AuthorizedWhenInUse :
            lm.startUpdatingLocation()
        case .NotDetermined:
            lm.stopUpdatingLocation()
            disabledLocationLabel()
        default:
            lm.stopUpdatingLocation()
            disabledLocationLabel()
        }
    }
    
    func locationManager(manager: CLLocationManager, didUpdateHeading newHeading: CLHeading) {
        var arg = newHeading.magneticHeading - newHeading.trueHeading
        if arg < 0 { arg += 360 }
        argLabel.text = String(format:"%.6f",arg)
        
        let northDir: CLLocationDirection =
            (northSwitch.selectedSegmentIndex == 0) ? newHeading.magneticHeading : newHeading.trueHeading
        compassFG.transform = CGAffineTransformMakeRotation(CGFloat(-northDir * M_PI/180))
        dirLabel.text = String(format:"%.6f",northDir)
        
    }
    
    func startHeadingService() {
        northSwitch.selectedSegmentIndex = 0
        lm.headingOrientation = .Portrait
        lm.headingFilter = 1
        lm.startUpdatingHeading()
    }
    
    func startLocationService() {
        lm.desiredAccuracy = kCLLocationAccuracyBest
        lm.distanceFilter = 1
        lm.startUpdatingLocation()
    }
    
    func disabledLocationLabel() {
        let msg = "位置情報の利用が未許可"
        lngLabel.text = msg
        latLabel.text = msg
        altLabel.text = msg
    }

    override func viewDidLoad() {
        super.viewDidLoad()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }


}

