//
//  FileAdd.swift
//  SwiftFileViewer
//
//  Created by Yoshihisa Nitta on 2016/06/26.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class FileAdd: UIViewController {

    @IBOutlet weak var myTextField: UITextField!
    @IBOutlet weak var myTextView: UITextView!
    @IBAction func tapCancel(sender: AnyObject) {
        dismissViewControllerAnimated(true, completion: nil)
    }
    @IBAction func tapAdd(sender: AnyObject) {
        var path:String = myTextField.text ?? ""
        if path.hasPrefix("/") {
            path = path.substringFromIndex(path.startIndex.successor())
        }
        path = NSHomeDirectory() + "/" + path
        let contents: String = myTextView.text ?? ""
        do {
            try contents.writeToFile(path, atomically:true, encoding:NSUTF8StringEncoding)
        } catch let error as NSError {
            let alert: UIAlertController = UIAlertController(title:"Add File", message: "error occurred: "+String(error),preferredStyle: UIAlertControllerStyle.Alert)
            alert.addAction(UIAlertAction(title:"Cancel",style:UIAlertActionStyle.Cancel,handler:nil))
            presentViewController(alert,animated:true, completion:nil)
            return;
        }
        dismissViewControllerAnimated(true, completion: nil)
    }
    @IBAction func tapMkdir(sender: AnyObject) {
        var path:String = myTextField.text ?? ""
        if path.hasPrefix("/") {
            path = path.substringFromIndex(path.startIndex.successor())
        }
        path = NSHomeDirectory() + "/" + path
        do {
            try NSFileManager.defaultManager().createDirectoryAtPath(path,withIntermediateDirectories:true, attributes: nil)
        } catch let error as NSError {
            let alert: UIAlertController = UIAlertController(title:"Make Dir", message: "error occurred: "+String(error),preferredStyle: UIAlertControllerStyle.Alert)
            alert.addAction(UIAlertAction(title:"Cancel",style:UIAlertActionStyle.Cancel,handler:nil))
            presentViewController(alert,animated:true, completion:nil)
            return;
        }
        dismissViewControllerAnimated(true, completion: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}
