//
//  ViewController.swift
//  SwiftCamera
//
//  Created by Yoshihisa Nitta on 2016/05/27.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {
    @IBOutlet weak var myImageView: UIImageView!
    @IBAction func goCamera(sender: AnyObject) {
        let camera = UIImagePickerControllerSourceType.Camera
        if UIImagePickerController.isSourceTypeAvailable(camera) {
            let picker = UIImagePickerController()
            picker.sourceType = camera
            picker.delegate = self
            presentViewController(picker, animated: true, completion: nil)
        } else {
            print("camera is unavailable")
        }
    }
    
    func imagePickerController(picker:UIImagePickerController, didFinishPickingMediaWithInfo info: [String : AnyObject]) {
        let image = info[UIImagePickerControllerOriginalImage] as! UIImage
        self.myImageView.image = image
        UIImageWriteToSavedPhotosAlbum(image,nil,nil,nil)
        dismissViewControllerAnimated(true, completion: nil)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

