//
//  ViewController.swift
//  SwiftAudioPlay
//
//  Created by Yoshihisa Nitta on 2016/07/01.
//  Copyright © 2016年 Yoshihisa Nitta. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController {
    
    var players:[AVAudioPlayer]!
    let audioFiles = ["download4817","download4801","download4763","download4691","download4685" ]

    @IBAction func tapSound1(sender: AnyObject) {
        play(0)
    }
    @IBAction func tapSound2(sender: AnyObject) {
        play(1)
   }
    @IBAction func tapSound3(sender: AnyObject) {
        play(2)
    }
    @IBAction func tapSound4(sender: AnyObject) {
        play(3)
    }
    @IBAction func tapSound5(sender: AnyObject) {
        play(4)
    }
    
    @IBOutlet weak var slider1: UISlider!
    @IBOutlet weak var slider2: UISlider!
    @IBOutlet weak var slider3: UISlider!
    @IBOutlet weak var slider4: UISlider!
    @IBOutlet weak var slider5: UISlider!
    @IBAction func volumeS1(sender: AnyObject) {
        setVolume(0,slider1.value)
    }
    @IBAction func volumeS2(sender: AnyObject) {
        setVolume(1,slider2.value)
    }
    @IBAction func volumeS3(sender: AnyObject) {
        setVolume(2,slider3.value)
    }
    @IBAction func volumeS4(sender: AnyObject) {
        setVolume(3,slider4.value)
    }
    @IBAction func volumeS5(sender: AnyObject) {
        setVolume(4,slider5.value)
   }
    
    func play(n:Int) {
        if n < players.count {
            if players[n].playing {
                players[n].stop()
                players[n].currentTime = 0.0
            }
            players[n].play()
        }
    }
    
    func setVolume(n:Int, _ value:Float) {
        if n < players.count {
            players[n].volume = value
        }
    }
    
    func setup() {
        players = []
        for fname in audioFiles {
            let path = NSURL(fileURLWithPath: NSBundle.mainBundle().pathForResource(fname, ofType: "mp3")!)
            do {
                let player = try AVAudioPlayer(contentsOfURL:path)
                players.append(player)
            } catch let error as NSError {
                print("error has occurred: \(error)")
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setup()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }

}

