﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.XR.iOS;
using System;

public class HitCreateEnvironmentProbe : MonoBehaviour 
{

	public float maxRayDistance = 30.0f;
	public LayerMask collisionLayer = 1 << 10;  //ARKitPlane layer 

	void CreateEnvironmentProbe(Matrix4x4 worldTransform)
	{
		//note we have not converted to Unity coord system yet, so we can pass it in directly
		UnityAREnvironmentProbeAnchorData anchorData;
		anchorData.ptrIdentifier = IntPtr.Zero;
		anchorData.probeExtent = Vector3.one;
		anchorData.transform = UnityARMatrixOps.GetMatrix (worldTransform); //this should be in ARKit coords
        anchorData.cubemapData.cubemapPtr = IntPtr.Zero;
        anchorData.cubemapData.textureFormat = UnityAREnvironmentTextureFormat.UnityAREnvironmentTextureFormatDefault;
        anchorData.cubemapData.width = 0;
        anchorData.cubemapData.height = 0;
        anchorData.cubemapData.mipmapCount = 0;
		anchorData = UnityARSessionNativeInterface.GetARSessionNativeInterface ().AddEnvironmentProbeAnchor (anchorData);
	}

	bool HitTestWithResultType (ARPoint point, ARHitTestResultType resultTypes)
	{
		List<ARHitTestResult> hitResults = UnityARSessionNativeInterface.GetARSessionNativeInterface ().HitTest (point, resultTypes);
		if (hitResults.Count > 0) {
			foreach (var hitResult in hitResults) {
				Debug.Log ("Got hit!");
				//note we have not converted to Unity coord system yet - since we are going to pass this back to ARKit
				CreateEnvironmentProbe (hitResult.worldTransform);
				return true;
			}
		}
		return false;
	}

	// Update is called once per frame
	void Update () {
		#if UNITY_EDITOR   //we will only use this script on the editor side, though there is nothing that would prevent it from working on device
		if (Input.GetMouseButtonDown (0)) {
			Ray ray = Camera.main.ScreenPointToRay (Input.mousePosition);
			RaycastHit hit;

			//we'll try to hit one of the plane collider gameobjects that were generated by the plugin
			//effectively similar to calling HitTest with ARHitTestResultType.ARHitTestResultTypeExistingPlaneUsingExtent
			if (Physics.Raycast (ray, out hit, maxRayDistance, collisionLayer)) 
			{
				//Create an environment probe anchor in editor
				//we're going to get the position from the contact point
				//m_HitTransform.position = hit.point;
				//Debug.Log (string.Format ("x:{0:0.######} y:{1:0.######} z:{2:0.######}", m_HitTransform.position.x, m_HitTransform.position.y, m_HitTransform.position.z));

				//and the rotation from the transform of the plane collider
				//m_HitTransform.rotation = hit.transform.rotation;
			}
		}
		#else
		if (Input.touchCount > 0)
		{
			var touch = Input.GetTouch(0);
			if (touch.phase == TouchPhase.Began)
			{
				var screenPosition = Camera.main.ScreenToViewportPoint(touch.position);
				ARPoint point = new ARPoint {
					x = screenPosition.x,
					y = screenPosition.y
				};

				// prioritize reults types
				ARHitTestResultType[] resultTypes = {
					//ARHitTestResultType.ARHitTestResultTypeExistingPlaneUsingGeometry,
					ARHitTestResultType.ARHitTestResultTypeExistingPlaneUsingExtent, 
					// if you want to use infinite planes use this:
					//ARHitTestResultType.ARHitTestResultTypeExistingPlane,
					//ARHitTestResultType.ARHitTestResultTypeEstimatedHorizontalPlane, 
					//ARHitTestResultType.ARHitTestResultTypeEstimatedVerticalPlane, 
					ARHitTestResultType.ARHitTestResultTypeFeaturePoint
				}; 

				foreach (ARHitTestResultType resultType in resultTypes)
				{
					if (HitTestWithResultType (point, resultType))
					{
						return;
					}
				}
			}
		}
		#endif

	}

}
