﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Sample03 : MonoBehaviour {
  public GameObject target;
  NtUnity.Kinect nt;
  Texture2D texture;
  
  void Start () {
    nt = new NtUnity.Kinect();
    texture = new Texture2D(NtUnity.Kinect.rgbCols,
			    NtUnity.Kinect.rgbRows,
			    TextureFormat.RGBA32,false);
  }
  void Update () {
    nt.setRGB();
    texture.SetPixels32(nt.rgbImage);
    texture.Apply();
    target.GetComponent<Renderer>().material.mainTexture = texture;
    // rotate cube
    target.transform.rotation = Quaternion.AngleAxis(Mathf.Rad2Deg * Time.time,
						     Vector3.up);
  }
  void OnApplicationQuit() {
    nt.stopKinect();
  }
}
